/*
 * Decompiled with CFR 0.152.
 */
package br.ufma.deinf.gia.labmint.semantics;

import br.ufma.deinf.gia.labmint.document.NclValidatorDocument;
import br.ufma.deinf.gia.labmint.message.MessageList;
import br.ufma.deinf.gia.labmint.semantics.ElementValidation;
import br.ufma.deinf.laws.util.MultiHashMap;
import java.io.File;
import java.net.URI;
import java.util.Vector;
import org.w3c.dom.Element;

public class Media
extends ElementValidation {
    String[] protocols = new String[]{"file:", "http:", "https", "rstp", "rtp", "ncl-mirror:", "sbtvd:"};
    private MultiHashMap types = null;
    private String idMedia = null;

    public Media(NclValidatorDocument doc) {
        super(doc);
        this.setTypes();
    }

    public boolean validate(Element eMedia) {
        boolean resultado = true;
        this.idMedia = eMedia.getAttribute("id");
        if (!this.hasValidMediaDescriptorAttribute(eMedia)) {
            resultado = false;
        }
        if (!this.hasValidMediaTypeAttribute(eMedia)) {
            resultado = false;
        }
        if (!this.hasValidMediaSrcAttribute(eMedia)) {
            resultado = false;
        }
        if (!this.hasValidMediaReferAttribute(eMedia)) {
            resultado = false;
        }
        if (!this.hasValidExtensionForMediaType(eMedia)) {
            resultado = false;
        }
        if (!eMedia.hasAttribute("refer")) {
            if (!eMedia.hasAttribute("src") && !eMedia.hasAttribute("type")) {
                MessageList.addError((String)this.doc.getId(), (int)4108, (Element)eMedia);
                resultado = false;
            }
        } else if (eMedia.hasAttribute("src")) {
            MessageList.addWarning((String)this.doc.getId(), (int)4107, (Element)eMedia);
            resultado = false;
        }
        return resultado;
    }

    private boolean hasValidMediaDescriptorAttribute(Element eMedia) {
        if (eMedia.hasAttribute("descriptor")) {
            String idDescriptor = eMedia.getAttribute("descriptor");
            Element element = this.doc.getElement(idDescriptor);
            if (element == null) {
                Vector<String> args = new Vector<String>();
                args.add(this.idMedia);
                MessageList.addError((String)this.doc.getId(), (int)4106, (Element)eMedia, args);
                return false;
            }
            if (element.getTagName().compareTo("descriptor") != 0 && element.getTagName().compareTo("descriptorSwitch") != 0) {
                Vector<String> args = new Vector<String>();
                args.add(this.idMedia);
                MessageList.addError((String)this.doc.getId(), (int)4106, (Element)eMedia, args);
                return false;
            }
        }
        return true;
    }

    private boolean hasValidMediaTypeAttribute(Element eMedia) {
        if (eMedia.hasAttribute("type")) {
            String type = eMedia.getAttribute("type");
            if (!this.types.containsKey((Object)type)) {
                Vector<String> args = new Vector<String>();
                args.add(type);
                MessageList.addWarning((String)this.doc.getId(), (int)4105, (Element)eMedia, args);
                return false;
            }
        } else if (!eMedia.hasAttribute("src") && !eMedia.hasAttribute("refer")) {
            MessageList.addError((String)this.doc.getId(), (int)4104, (Element)eMedia);
            return false;
        }
        return true;
    }

    private boolean hasValidMediaSrcAttribute(Element eMedia) {
        if (eMedia.hasAttribute("src")) {
            String src = eMedia.getAttribute("src");
            src = src.replaceAll(" ", "%20");
            int i = 0;
            while (i < this.protocols.length) {
                if (src.contains(this.protocols[i])) {
                    block12: {
                        URI uri;
                        block13: {
                            try {
                                uri = new URI(src);
                                if (uri.isAbsolute()) {
                                    File fMedia = new File(uri);
                                    break block12;
                                }
                                uri = new URI(String.valueOf(this.doc.getDir()) + src);
                                if (uri.isAbsolute()) break block13;
                                Vector<String> args = new Vector<String>();
                                args.add(src);
                                MessageList.addWarning((String)this.doc.getId(), (int)4103, (Element)eMedia, args);
                                return false;
                            }
                            catch (Exception e) {
                                Vector<String> args = new Vector<String>();
                                args.add(src);
                                MessageList.addWarning((String)this.doc.getId(), (int)4103, (Element)eMedia, args);
                                return false;
                            }
                        }
                        File fMedia = new File(uri);
                        if (!fMedia.exists()) {
                            Vector<String> args = new Vector<String>();
                            args.add(src);
                            MessageList.addWarning((String)this.doc.getId(), (int)4103, (Element)eMedia, args);
                            return false;
                        }
                    }
                    return true;
                }
                ++i;
            }
            File fMedia = new File(src);
            if (fMedia.isFile()) {
                return true;
            }
            try {
                URI uri = new URI(String.valueOf(this.doc.getDir()) + src);
                fMedia = new File(uri);
                if (!fMedia.isFile()) {
                    Vector<String> args = new Vector<String>();
                    args.add(src);
                    MessageList.addWarning((String)this.doc.getId(), (int)4103, (Element)eMedia, args);
                    return false;
                }
            }
            catch (Exception e) {
                Vector<String> args = new Vector<String>();
                args.add(src);
                MessageList.addWarning((String)this.doc.getId(), (int)4103, (Element)eMedia, args);
                return false;
            }
        }
        return true;
    }

    private boolean hasValidMediaIDAttribute(Element eMedia) {
        return true;
    }

    private boolean hasValidMediaReferAttribute(Element eMedia) {
        if (eMedia.hasAttribute("refer")) {
            String idRefer = eMedia.getAttribute("refer");
            Element element = this.doc.getElement(idRefer);
            if (element == null) {
                Vector<String> args = new Vector<String>();
                args.add(idRefer);
                MessageList.addError((String)this.doc.getId(), (int)4102, (Element)eMedia, args);
                return false;
            }
            if (element.getTagName().compareTo("media") != 0) {
                Vector<String> args = new Vector<String>();
                args.add(idRefer);
                MessageList.addError((String)this.doc.getId(), (int)4102, (Element)eMedia, args);
                return false;
            }
            if (element.hasAttribute("refer")) {
                Vector<String> args = new Vector<String>();
                args.add(idRefer);
                MessageList.addError((String)this.doc.getId(), (int)4109, (Element)eMedia, args);
                return false;
            }
        }
        return true;
    }

    private boolean hasValidMediaNewInstanceAttribute(Element eMedia) {
        return true;
    }

    private boolean hasValidExtension(Element eMedia) {
        return true;
    }

    private boolean hasValidExtensionForMediaType(Element eMedia) {
        if (eMedia.hasAttribute("src") && eMedia.hasAttribute("type")) {
            String type = eMedia.getAttribute("type");
            String src = eMedia.getAttribute("src");
            String extension = this.getExtension(src);
            if (!this.types.containsKey((Object)type) || !this.types.get(type).contains(extension)) {
                Vector<String> args = new Vector<String>();
                args.add(type);
                args.add(this.idMedia);
                MessageList.addWarning((String)this.doc.getId(), (int)4101, (Element)eMedia, args);
            }
        }
        return true;
    }

    private String getExtension(String src) {
        String extension = "";
        int i = src.length() - 1;
        while (i >= 0) {
            if (src.charAt(i) == '.') break;
            extension = String.valueOf(src.charAt(i)) + extension;
            --i;
        }
        return extension;
    }

    private void setTypes() {
        if (this.types == null) {
            this.types = new MultiHashMap();
            this.types.put((Object)"text/html", (Object)"html");
            this.types.put((Object)"text/html", (Object)"htm");
            this.types.put((Object)"text/css", (Object)"css");
            this.types.put((Object)"text/xml", (Object)"xml");
            this.types.put((Object)"image/bmp", (Object)"bmp");
            this.types.put((Object)"image/png", (Object)"png");
            this.types.put((Object)"image/mng", (Object)"mng");
            this.types.put((Object)"image/gif", (Object)"gif");
            this.types.put((Object)"image/jpeg", (Object)"jpg");
            this.types.put((Object)"image/jpeg", (Object)"jpeg");
            this.types.put((Object)"audio/basic", (Object)"wav");
            this.types.put((Object)"audio/mp3", (Object)"mp3");
            this.types.put((Object)"audio/mp2", (Object)"mp2");
            this.types.put((Object)"audio/mpeg", (Object)"mpeg");
            this.types.put((Object)"audio/mpeg", (Object)"mpg");
            this.types.put((Object)"audio/mpeg4", (Object)"mp4");
            this.types.put((Object)"audio/mpeg4", (Object)"mpg4");
            this.types.put((Object)"video/mpeg", (Object)"mpeg");
            this.types.put((Object)"video/mpeg", (Object)"mpg");
            this.types.put((Object)"application/x-ginga-NCL", (Object)"ncl");
            this.types.put((Object)"application/x-ncl-NCL", (Object)"ncl");
            this.types.put((Object)"application/x-ginga-NCLua", (Object)"lua");
            this.types.put((Object)"application/x-ncl-NCLua", (Object)"lua");
            this.types.put((Object)"application/x-ginga-NCLet", (Object)"class");
            this.types.put((Object)"application/x-ncl-NCLet", (Object)"class");
            this.types.put((Object)"application/x-ginga-NCLet", (Object)"jar");
            this.types.put((Object)"application/x-ncl-NCLet", (Object)"jar");
            this.types.put((Object)"application/x-ginga-settings", (Object)"");
            this.types.put((Object)"application/x-ncl-settings", (Object)"");
            this.types.put((Object)"application/x-ginga-time", (Object)"");
            this.types.put((Object)"application/x-ncl-time", (Object)"");
        }
    }
}

