/*
 * Decompiled with CFR 0.152.
 */
package br.ufma.deinf.laws.ncleclipse.hyperlinks;

import br.ufma.deinf.laws.ncl.NCLStructure;
import br.ufma.deinf.laws.ncleclipse.NCLEditor;
import br.ufma.deinf.laws.ncleclipse.NCLMultiPageEditor;
import br.ufma.deinf.laws.ncleclipse.document.NCLSourceDocument;
import br.ufma.deinf.laws.ncleclipse.hyperlinks.NCLEclipseHyperlink;
import br.ufma.deinf.laws.ncleclipse.ncl.NCLContentHandler;
import br.ufma.deinf.laws.ncleclipse.ncl.NCLDocument;
import br.ufma.deinf.laws.ncleclipse.ncl.NCLElement;
import br.ufma.deinf.laws.ncleclipse.ncl.NCLParser;
import java.io.File;
import java.util.Collection;
import java.util.Vector;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.hyperlink.IHyperlink;
import org.eclipse.jface.text.hyperlink.IHyperlinkDetector;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.xml.sax.ContentHandler;

public class NCLEclipseHyperlinkDetector
implements IHyperlinkDetector {
    ITextViewer textViewer = null;

    public NCLEclipseHyperlinkDetector(ITextViewer textViewer) {
        this.textViewer = textViewer;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IHyperlink[] detectHyperlinks(ITextViewer textViewer, IRegion region, boolean canShowMultipleHyperlinks) {
        String line;
        IRegion lineInfo;
        int offset = region.getOffset();
        NCLSourceDocument doc = (NCLSourceDocument)textViewer.getDocument();
        boolean tmp = false;
        if (!tmp) {
            try {
                ITypedRegion typedRegion = doc.getPartition(region.getOffset());
                if (typedRegion.getType() != "__xml_start_tag") {
                    return null;
                }
                String tagname = doc.getCurrentTagname(offset);
                int startRegionOffset = typedRegion.getOffset();
                if (!doc.isAttributeValue(offset)) return null;
                String currentAttr = doc.getCurrentAttribute(offset);
                String attrValue = doc.getAttributeValueFromCurrentTagName(offset, currentAttr);
                int startAttributeValue = doc.getStartAttributeValueOffset(offset) + 1;
                if (startAttributeValue == -1) return null;
                if (attrValue.equals("")) return null;
                NCLStructure nclStructure = NCLStructure.getInstance();
                Collection nclReference = nclStructure.getNCLReference(tagname, currentAttr);
                if (nclReference != null && nclReference.size() != 0) {
                    Region region1 = new Region(startAttributeValue, attrValue.length());
                    return new IHyperlink[]{new NCLEclipseHyperlink(textViewer, (IRegion)region1, attrValue)};
                }
                Collection c = nclStructure.getNCLReverseReference(tagname, currentAttr);
                IWorkbench wb = PlatformUI.getWorkbench();
                IWorkbenchWindow win = wb.getActiveWorkbenchWindow();
                IWorkbenchPage page = win.getActivePage();
                NCLEditor editor = ((NCLMultiPageEditor)page.getActiveEditor()).getNCLEditor();
                String nclText = editor.getInputDocument().get();
                NCLContentHandler nclContentHandler = new NCLContentHandler();
                NCLDocument nclDocument = new NCLDocument();
                File currentFile = editor.getCurrentFile();
                nclDocument.setParentURI(currentFile.getParentFile().toURI());
                nclContentHandler.setNclDocument(nclDocument);
                NCLParser parser = new NCLParser();
                parser.setContentHandler((ContentHandler)nclContentHandler);
                parser.doParse(nclText);
                Vector v = nclDocument.getElements(tagname, attrValue);
                if (v == null) {
                    return null;
                }
                NCLEclipseHyperlink[] values = new NCLEclipseHyperlink[v.size() + 1];
                if (c == null) return null;
                if (c.size() == 0) return null;
                if (v == null) return null;
                Region region1 = new Region(startAttributeValue, attrValue.length());
                int i = 0;
                while (true) {
                    if (i >= v.size()) {
                        values[v.size()] = new NCLEclipseHyperlink(textViewer, (IRegion)new Region(startAttributeValue, attrValue.length()), "");
                        return values;
                    }
                    values[i] = new NCLEclipseHyperlink(textViewer, (IRegion)region1, ((NCLElement)v.get(i)).getAttributeValue("id"), (NCLElement)v.get(i));
                    ++i;
                }
            }
            catch (BadLocationException tagname) {
                // empty catch block
            }
            return null;
        }
        try {
            lineInfo = doc.getLineInformationOfOffset(offset);
            line = doc.get(lineInfo.getOffset(), lineInfo.getLength());
        }
        catch (BadLocationException ex) {
            return null;
        }
        int begin = line.indexOf("<");
        int end = line.indexOf(">");
        if (end < 0) return null;
        if (begin < 0) return null;
        if (end == begin + 1) {
            return null;
        }
        String text = line.substring(begin + 1, end);
        Region region1 = new Region(lineInfo.getOffset() + begin + 1, text.length() - 1);
        return new IHyperlink[]{new NCLEclipseHyperlink(textViewer, (IRegion)region1, text)};
    }
}

