/*
 * Decompiled with CFR 0.152.
 */
package br.ufma.deinf.gia.labmint.document;

import br.ufma.deinf.gia.labmint.message.MessageList;
import br.ufma.deinf.gia.labmint.xml.XMLParserExtend;
import br.ufma.deinf.laws.util.DocumentUtil;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class NclValidatorDocument {
    protected Map<String, Element> elements;
    protected Map<String, NclValidatorDocument> aliases;
    protected Element root;
    protected String id;
    protected String path;
    NclValidatorDocument father;
    String[] protocols = new String[]{"file:", "http:", "https", "rstp", "rtp", "ncl-mirror:", "sbtvd:"};

    public NclValidatorDocument(NclValidatorDocument father, Document doc) throws ParserConfigurationException, URISyntaxException, SAXException, IOException {
        this.father = father;
        this.elements = new HashMap();
        this.aliases = new HashMap();
        this.root = doc.getDocumentElement();
        this.path = doc.getBaseURI();
        this.id = null;
        if (this.root.hasAttribute("id")) {
            this.id = this.root.getAttribute("id");
        } else {
            NodeList nodeList = this.root.getChildNodes();
            int i = 0;
            while (i < nodeList.getLength()) {
                Element element;
                Node node = nodeList.item(i);
                if (node.getNodeType() == 1 && (element = (Element)node).getTagName().compareTo("body") == 0 && element.hasAttribute("id")) {
                    this.id = element.getAttribute("id");
                }
                ++i;
            }
        }
        this.parse(this.root);
    }

    public String getId() {
        return this.id;
    }

    public Element getDocumentElement() {
        return this.root;
    }

    public Element getElement(String id) {
        if (this.elements.containsKey(id)) {
            return (Element)this.elements.get(id);
        }
        if (id.indexOf("#") < 0) {
            return null;
        }
        if (id.indexOf("#") != id.lastIndexOf("#")) {
            return null;
        }
        int index = id.indexOf("#");
        String alias = id.substring(0, index);
        String docId = id.substring(index + 1);
        if (!this.aliases.containsKey(alias)) {
            return null;
        }
        NclValidatorDocument doc = (NclValidatorDocument)this.aliases.get(alias);
        return doc.getElement(docId);
    }

    protected void parse(Element root) {
        if (root.hasAttribute("id")) {
            String id = root.getAttribute("id");
            if (!this.elements.containsKey(id)) {
                this.elements.put(id, root);
            } else {
                Vector<String> args = new Vector<String>();
                args.add(id);
                MessageList.addError((String)this.id, (int)3001, (Element)root, args);
            }
        }
        if (root.getTagName().equals("importBase") || root.getTagName().equals("importNCL") || root.getTagName().equals("link")) {
            if (root.hasAttribute("alias") || root.hasAttribute("xconnector")) {
                String caminho = "";
                String att = "";
                String alias = "";
                boolean auxiliar = false;
                if (root.hasAttribute("documentURI")) {
                    caminho = root.getAttribute("documentURI");
                    att = "documentURI";
                    alias = root.getAttribute("alias");
                }
                if (caminho.equals("") && root.hasAttribute("xconnector")) {
                    caminho = root.getAttribute("xconnector");
                    int index = caminho.indexOf("#");
                    if (index != -1) {
                        caminho = caminho.substring(0, index);
                    }
                    caminho = this.aliases.containsKey(caminho) ? ((NclValidatorDocument)this.aliases.get(caminho)).getPath() : caminho;
                    att = "xconnector";
                    alias = caminho;
                    auxiliar = true;
                    if (index == -1) {
                        return;
                    }
                }
                if (!caminho.equals("")) {
                    try {
                        XMLParserExtend parser = new XMLParserExtend();
                        Document doc = null;
                        URI uri = new URI(caminho);
                        NclValidatorDocument father = this;
                        String fullpath = DocumentUtil.getAbsoluteFileName((String)this.getPath(), (String)uri.getPath());
                        while (father != null) {
                            if (fullpath.equals(father.getPath())) {
                                Vector<String> args = new Vector<String>();
                                args.add(uri.getPath());
                                MessageList.addError((String)this.id, (int)3103, (Element)root, args);
                                return;
                            }
                            father = father.getFather();
                        }
                        if (uri.isAbsolute()) {
                            parser.parse(uri.getPath());
                            doc = parser.getDocument();
                        } else {
                            parser.parse(DocumentUtil.getAbsoluteFileName((String)this.getPath(), (String)caminho));
                            doc = parser.getDocument();
                        }
                        if (!this.addDocument(alias, new NclValidatorDocument(this, doc)) && !auxiliar) {
                            Vector<String> args = new Vector<String>();
                            args.add(alias);
                            MessageList.addError((String)this.id, (int)3002, (Element)root, args);
                        }
                    }
                    catch (Exception e) {
                        Vector<String> args = new Vector<String>();
                        args.add(e.getMessage());
                        MessageList.addError((String)this.id, (int)1003, (Element)root, args);
                    }
                } else {
                    MessageList.addError((String)this.getPath(), (int)3101, (Element)root);
                }
            } else {
                MessageList.addError((String)this.getPath(), (int)3102, (Element)root);
            }
        }
        NodeList nodeList = root.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Node node = nodeList.item(i);
            if (node.getNodeType() == 1) {
                this.parse((Element)node);
            }
            ++i;
        }
    }

    public boolean addDocument(String alias, NclValidatorDocument doc) {
        if (this.aliases.containsKey(alias)) {
            return false;
        }
        this.aliases.put(alias, doc);
        return true;
    }

    public NclValidatorDocument getFather() {
        return this.father;
    }

    public Map<String, NclValidatorDocument> getAliases() {
        return this.aliases;
    }

    public void setAliases(Map<String, NclValidatorDocument> aliases) {
        this.aliases = aliases;
    }

    public Map<String, Element> getElements() {
        return this.elements;
    }

    public void setElements(Map<String, Element> elements) {
        this.elements = elements;
    }

    public String getPath() {
        return this.path;
    }

    public void setPath(String path) {
        this.path = path;
    }

    public Element getRoot() {
        return this.root;
    }

    public void setRoot(Element root) {
        this.root = root;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getDir() {
        String path = this.getPath();
        int i = path.length() - 1;
        while (i >= 0) {
            if (path.charAt(i) == '/') {
                return path.substring(0, i + 1);
            }
            --i;
        }
        return path;
    }

    public Element getElementInContext(String idContext, String id) {
        if (this.elements.containsKey(idContext)) {
            Element context = (Element)this.elements.get(idContext);
            NodeList nodeList = context.getChildNodes();
            int i = 0;
            while (i < nodeList.getLength()) {
                Element child;
                Node node = nodeList.item(i);
                if (node.getNodeType() == 1 && (child = (Element)node).getAttribute("id").equals(id)) {
                    return child;
                }
                ++i;
            }
        }
        return null;
    }

    public Element getElementChild(Element parent, String id) {
        if (parent == null) {
            return null;
        }
        NodeList nodeList = parent.getChildNodes();
        int i = 0;
        while (i < nodeList.getLength()) {
            Element child;
            Node node = nodeList.item(i);
            if (node.getNodeType() == 1 && (child = (Element)node).getAttribute("id").equals(id)) {
                return child;
            }
            ++i;
        }
        return null;
    }

    public boolean validateSrc(String src, Element element) {
        src = src.replaceAll(" ", "%20");
        int i = 0;
        while (i < this.protocols.length) {
            if (src.contains(this.protocols[i])) {
                block11: {
                    URI uri;
                    block12: {
                        try {
                            uri = new URI(src);
                            if (uri.isAbsolute()) {
                                File fMedia = new File(uri);
                                break block11;
                            }
                            uri = new URI(String.valueOf(this.getDir()) + src);
                            if (uri.isAbsolute()) break block12;
                            Vector<String> args = new Vector<String>();
                            args.add(src);
                            MessageList.addWarning((String)this.getId(), (int)4103, (Element)element, args);
                            return false;
                        }
                        catch (Exception e) {
                            Vector<String> args = new Vector<String>();
                            args.add(src);
                            MessageList.addWarning((String)this.getId(), (int)4103, (Element)element, args);
                            return false;
                        }
                    }
                    File fMedia = new File(uri);
                    if (!fMedia.exists()) {
                        Vector<String> args = new Vector<String>();
                        args.add(src);
                        MessageList.addWarning((String)this.getId(), (int)4103, (Element)element, args);
                        return false;
                    }
                }
                return true;
            }
            ++i;
        }
        File fMedia = new File(src);
        if (fMedia.isFile()) {
            return true;
        }
        try {
            URI uri = new URI(String.valueOf(this.getDir()) + src);
            fMedia = new File(uri);
            if (!fMedia.isFile()) {
                Vector<String> args = new Vector<String>();
                args.add(src);
                MessageList.addWarning((String)this.getId(), (int)4103, (Element)element, args);
                return false;
            }
        }
        catch (Exception e) {
            Vector<String> args = new Vector<String>();
            args.add(src);
            MessageList.addWarning((String)this.getId(), (int)4103, (Element)element, args);
            return false;
        }
        return false;
    }
}

