/*
 * Decompiled with CFR 0.152.
 */
package br.ufma.deinf.laws.ncleclipse.launch;

import br.ufma.deinf.laws.ncleclipse.launch.util.GingaVMRemoteUtility;
import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.LaunchConfigurationDelegate;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IFileEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;

public class GingaVMLaunchConfiguration
extends LaunchConfigurationDelegate {
    public void launch(ILaunchConfiguration configuration, String mode, ILaunch launch, IProgressMonitor monitor) throws CoreException {
        IEditorInput input;
        IEditorPart editor;
        IWorkbenchPage page;
        String hostName = configuration.getAttribute("hostName", "192.168.64.129");
        String userName = configuration.getAttribute("userName", "root");
        String userPassword = configuration.getAttribute("hostPassword", "telemidia");
        String remoteLauncher = configuration.getAttribute("remoteLauncher", "/misc/launcher.sh");
        String remoteWorkspace = configuration.getAttribute("remoteWorkspace", "/misc/ncl30");
        String workspace = ResourcesPlugin.getWorkspace().getRoot().getLocation().toString();
        IFile activeFile = null;
        IProject activeProject = null;
        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        IWorkbenchWindow window = windows[0];
        if (window != null && (page = window.getActivePage()) != null && (editor = page.getActiveEditor()) != null && (input = editor.getEditorInput()) instanceof IFileEditorInput) {
            IFileEditorInput fileInput = (IFileEditorInput)input;
            activeFile = fileInput.getFile();
            activeProject = fileInput.getFile().getProject();
        }
        MessageConsole console = new MessageConsole("Ginga-NCL VM Player - " + userName + "@" + hostName, null);
        console.activate();
        console.clearConsole();
        ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{console});
        MessageConsoleStream consoleStream = console.newMessageStream();
        consoleStream.println("Validating values...");
        if (activeFile == null || activeProject == null) {
            consoleStream.println("Fail!");
            return;
        }
        consoleStream.println("Done!");
        GingaVMRemoteUtility remoteUtility = new GingaVMRemoteUtility(hostName, userName, userPassword, consoleStream, remoteLauncher, remoteWorkspace, "");
        remoteUtility.setVerboseMode(true);
        String workspaceProject = activeProject.getFullPath().toString();
        String workspaceProjectFile = activeFile.getFullPath().toString();
        consoleStream.println("Connecting to server...");
        try {
            remoteUtility.connect();
            consoleStream.println("Done!");
        }
        catch (IOException e) {
            consoleStream.println("Fail!");
            return;
        }
        consoleStream.println("Synchronizing clocks...");
        long ctime = System.currentTimeMillis();
        try {
            remoteUtility.exec("date --rfc-3339=\"" + ctime + "\"");
            consoleStream.println("Done!");
        }
        catch (IOException e) {
            consoleStream.println("Fail!");
            return;
        }
        consoleStream.println("Copying files to server...");
        try {
            remoteUtility.commit(String.valueOf(workspace) + workspaceProject);
            consoleStream.println("Done!");
        }
        catch (IOException e) {
            consoleStream.println("Fail!");
            return;
        }
        consoleStream.println("Playing application on server...");
        try {
            remoteUtility.play(String.valueOf(remoteWorkspace) + workspaceProjectFile);
            consoleStream.println("Done!");
        }
        catch (IOException e) {
            consoleStream.println("Fail!");
            return;
        }
    }
}

