/*
 * Decompiled with CFR 0.152.
 */
package br.ufma.deinf.laws.ncleclipse.preferences;

import br.ufma.deinf.laws.ncleclipse.NCLEditorMessages;
import org.eclipse.core.runtime.Assert;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.swt.custom.TableEditor;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;

public abstract class TableFieldEditor
extends FieldEditor {
    private Table table;
    private Composite buttonBox;
    private Button addButton;
    private Button duplicateButton;
    private Button removeButton;
    private Button upButton;
    private Button downButton;
    private SelectionListener selectionListener;
    private final String[] columnNames;
    private final int[] columnWidths;

    protected TableFieldEditor() {
        this.columnNames = new String[0];
        this.columnWidths = new int[0];
    }

    protected TableFieldEditor(String name, String labelText, String[] columnNames, int[] columnWidths, Composite parent) {
        this.init(name, labelText);
        this.columnNames = columnNames;
        this.columnWidths = columnWidths;
        this.createControl(parent);
    }

    protected abstract String createList(String[][] var1);

    protected abstract String[][] parseString(String var1);

    protected abstract String[] getNewInputObject();

    private void createButtons(Composite box) {
        this.addButton = this.createPushButton(box, NCLEditorMessages.getInstance().getString("New"));
        this.duplicateButton = this.createPushButton(box, NCLEditorMessages.getInstance().getString("Duplicate"));
        this.removeButton = this.createPushButton(box, NCLEditorMessages.getInstance().getString("Remove"));
        this.upButton = this.createPushButton(box, NCLEditorMessages.getInstance().getString("Up"));
        this.downButton = this.createPushButton(box, NCLEditorMessages.getInstance().getString("Down"));
    }

    protected Button getAddButton() {
        return this.addButton;
    }

    protected Button getDuplicateButton() {
        return this.duplicateButton;
    }

    protected Button getRemoveButton() {
        return this.removeButton;
    }

    protected Button getUpButton() {
        return this.upButton;
    }

    protected Button getDownButton() {
        return this.downButton;
    }

    private Button createPushButton(Composite parent, String key) {
        Button button = new Button(parent, 8);
        button.setText(key);
        button.setFont(parent.getFont());
        GridData data = new GridData(768);
        int widthHint = this.convertHorizontalDLUsToPixels((Control)button, 61);
        data.widthHint = Math.max(widthHint, button.computeSize((int)-1, (int)-1, (boolean)true).x);
        button.setLayoutData((Object)data);
        button.addSelectionListener(this.getSelectionListener());
        return button;
    }

    protected void adjustForNumColumns(int numColumns) {
        Label control = this.getLabelControl();
        ((GridData)control.getLayoutData()).horizontalSpan = numColumns;
        ((GridData)this.table.getLayoutData()).horizontalSpan = numColumns - 1;
    }

    public void createSelectionListener() {
        this.selectionListener = new /* Unavailable Anonymous Inner Class!! */;
    }

    protected void doFillIntoGrid(Composite parent, int numColumns) {
        Label control = this.getLabelControl(parent);
        GridData gd = new GridData();
        gd.horizontalSpan = numColumns;
        control.setLayoutData((Object)gd);
        Composite composite = new Composite(parent, 0);
        GridData gridData = new GridData(4, 1, true, false);
        gridData.horizontalSpan = 2;
        gridData.widthHint = 550;
        composite.setLayoutData((Object)gridData);
        composite.setLayout((Layout)new GridLayout(2, false));
        this.table = this.getTableControl(composite);
        gd = new GridData(768);
        gd.verticalAlignment = 4;
        gd.horizontalSpan = numColumns - 1;
        gd.grabExcessHorizontalSpace = true;
        this.table.setLayoutData((Object)gd);
        this.buttonBox = this.getButtonBoxControl(composite);
        gd = new GridData();
        gd.verticalAlignment = 1;
        this.buttonBox.setLayoutData((Object)gd);
    }

    protected void doLoad() {
        if (this.table != null) {
            String s = this.getPreferenceStore().getString(this.getPreferenceName());
            String[][] array = this.parseString(s);
            int i = 0;
            while (i < array.length) {
                TableItem tableItem = new TableItem(this.table, 0);
                tableItem.setText(array[i]);
                ++i;
            }
        }
    }

    protected void doLoadDefault() {
        if (this.table != null) {
            this.table.removeAll();
            String s = this.getPreferenceStore().getDefaultString(this.getPreferenceName());
            String[][] array = this.parseString(s);
            int i = 0;
            while (i < array.length) {
                TableItem tableItem = new TableItem(this.table, 0);
                tableItem.setText(array[i]);
                ++i;
            }
        }
    }

    protected void doStore() {
        TableItem[] items = this.table.getItems();
        String[][] commands = new String[items.length][];
        int i = 0;
        while (i < items.length) {
            commands[i] = new String[this.columnNames.length];
            TableItem item = items[i];
            int j = 0;
            while (j < this.columnNames.length) {
                commands[i][j] = item.getText(j);
                ++j;
            }
            ++i;
        }
        String s = this.createList(commands);
        if (s != null) {
            this.getPreferenceStore().setValue(this.getPreferenceName(), s);
        }
    }

    public Composite getButtonBoxControl(Composite parent) {
        if (this.buttonBox == null) {
            this.buttonBox = new Composite(parent, 0);
            GridLayout layout = new GridLayout();
            layout.marginWidth = 0;
            this.buttonBox.setLayout((Layout)layout);
            this.createButtons(this.buttonBox);
            this.buttonBox.addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
        } else {
            this.checkParent((Control)this.buttonBox, parent);
        }
        this.selectionChanged();
        return this.buttonBox;
    }

    public Table getTableControl(Composite parent) {
        if (this.table == null) {
            this.table = new Table(parent, 68356);
            this.table.setFont(parent.getFont());
            this.table.setLinesVisible(true);
            this.table.setHeaderVisible(true);
            this.table.addSelectionListener(this.getSelectionListener());
            this.table.addDisposeListener((DisposeListener)new /* Unavailable Anonymous Inner Class!! */);
            String[] stringArray = this.columnNames;
            int n = this.columnNames.length;
            int n2 = 0;
            while (n2 < n) {
                String columnName = stringArray[n2];
                TableColumn tableColumn = new TableColumn(this.table, 16384);
                tableColumn.setText(columnName);
                tableColumn.setWidth(100);
                ++n2;
            }
            if (this.columnNames.length > 0) {
                TableLayout layout = new TableLayout();
                if (this.columnNames.length > 1) {
                    int i = 0;
                    while (i < this.columnNames.length - 1) {
                        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(0, this.columnWidths[i], false));
                        ++i;
                    }
                }
                layout.addColumnData((ColumnLayoutData)new ColumnWeightData(100, this.columnWidths[this.columnNames.length - 1], true));
                this.table.setLayout((Layout)layout);
            }
            TableEditor editor = new TableEditor(this.table);
            editor.horizontalAlignment = 16384;
            editor.grabHorizontal = true;
            this.table.addListener(8, (Listener)new /* Unavailable Anonymous Inner Class!! */);
        } else {
            this.checkParent((Control)this.table, parent);
        }
        return this.table;
    }

    public int getNumberOfControls() {
        return 2;
    }

    private SelectionListener getSelectionListener() {
        if (this.selectionListener == null) {
            this.createSelectionListener();
        }
        return this.selectionListener;
    }

    protected Shell getShell() {
        if (this.addButton == null) {
            return null;
        }
        return this.addButton.getShell();
    }

    private void addPressed() {
        this.setPresentsDefaultValue(false);
        String[] newInputObject = this.getNewInputObject();
        TableItem tableItem = new TableItem(this.table, 0);
        tableItem.setText(newInputObject);
        this.selectionChanged();
    }

    private void duplicatePressed() {
        this.setPresentsDefaultValue(false);
        int index = this.table.getSelectionIndex();
        int target = index + 1;
        if (index >= 0) {
            TableItem[] selection = this.table.getSelection();
            Assert.isTrue((selection.length == 1 ? 1 : 0) != 0);
            String[] values = new String[this.columnNames.length];
            int j = 0;
            while (j < this.columnNames.length) {
                values[j] = selection[0].getText(j);
                ++j;
            }
            TableItem tableItem = new TableItem(this.table, 0, target);
            tableItem.setText(values);
            this.table.setSelection(target);
        }
        this.selectionChanged();
    }

    private void removePressed() {
        this.setPresentsDefaultValue(false);
        int index = this.table.getSelectionIndex();
        if (index >= 0) {
            this.table.remove(index);
            this.selectionChanged();
        }
    }

    private void upPressed() {
        this.swap(true);
    }

    private void downPressed() {
        this.swap(false);
    }

    protected void selectionChanged() {
        int index = this.table.getSelectionIndex();
        int size = this.table.getItemCount();
        this.duplicateButton.setEnabled(index >= 0);
        this.removeButton.setEnabled(index >= 0);
        this.upButton.setEnabled(size > 1 && index > 0);
        this.downButton.setEnabled(size > 1 && index >= 0 && index < size - 1);
    }

    public void setFocus() {
        if (this.table != null) {
            this.table.setFocus();
        }
    }

    private void swap(boolean up) {
        int target;
        this.setPresentsDefaultValue(false);
        int index = this.table.getSelectionIndex();
        int n = target = up ? index - 1 : index + 1;
        if (index >= 0) {
            TableItem[] selection = this.table.getSelection();
            Assert.isTrue((selection.length == 1 ? 1 : 0) != 0);
            String[] values = new String[this.columnNames.length];
            int j = 0;
            while (j < this.columnNames.length) {
                values[j] = selection[0].getText(j);
                ++j;
            }
            this.table.remove(index);
            TableItem tableItem = new TableItem(this.table, 0, target);
            tableItem.setText(values);
            this.table.setSelection(target);
        }
        this.selectionChanged();
    }

    public void setEnabled(boolean enabled, Composite parent) {
        super.setEnabled(enabled, parent);
        this.getTableControl(parent).setEnabled(enabled);
        this.addButton.setEnabled(enabled);
        this.duplicateButton.setEnabled(enabled);
        this.removeButton.setEnabled(enabled);
        this.upButton.setEnabled(enabled);
        this.downButton.setEnabled(enabled);
    }

    static /* synthetic */ Button access$0(TableFieldEditor tableFieldEditor) {
        return tableFieldEditor.addButton;
    }

    static /* synthetic */ void access$1(TableFieldEditor tableFieldEditor) {
        tableFieldEditor.addPressed();
    }

    static /* synthetic */ Button access$2(TableFieldEditor tableFieldEditor) {
        return tableFieldEditor.duplicateButton;
    }

    static /* synthetic */ void access$3(TableFieldEditor tableFieldEditor) {
        tableFieldEditor.duplicatePressed();
    }

    static /* synthetic */ Button access$4(TableFieldEditor tableFieldEditor) {
        return tableFieldEditor.removeButton;
    }

    static /* synthetic */ void access$5(TableFieldEditor tableFieldEditor) {
        tableFieldEditor.removePressed();
    }

    static /* synthetic */ Button access$6(TableFieldEditor tableFieldEditor) {
        return tableFieldEditor.upButton;
    }

    static /* synthetic */ void access$7(TableFieldEditor tableFieldEditor) {
        tableFieldEditor.upPressed();
    }

    static /* synthetic */ Button access$8(TableFieldEditor tableFieldEditor) {
        return tableFieldEditor.downButton;
    }

    static /* synthetic */ void access$9(TableFieldEditor tableFieldEditor) {
        tableFieldEditor.downPressed();
    }

    static /* synthetic */ Table access$10(TableFieldEditor tableFieldEditor) {
        return tableFieldEditor.table;
    }

    static /* synthetic */ void access$11(TableFieldEditor tableFieldEditor, Button button) {
        tableFieldEditor.addButton = button;
    }

    static /* synthetic */ void access$12(TableFieldEditor tableFieldEditor, Button button) {
        tableFieldEditor.duplicateButton = button;
    }

    static /* synthetic */ void access$13(TableFieldEditor tableFieldEditor, Button button) {
        tableFieldEditor.removeButton = button;
    }

    static /* synthetic */ void access$14(TableFieldEditor tableFieldEditor, Button button) {
        tableFieldEditor.upButton = button;
    }

    static /* synthetic */ void access$15(TableFieldEditor tableFieldEditor, Button button) {
        tableFieldEditor.downButton = button;
    }

    static /* synthetic */ void access$16(TableFieldEditor tableFieldEditor, Composite composite) {
        tableFieldEditor.buttonBox = composite;
    }

    static /* synthetic */ void access$17(TableFieldEditor tableFieldEditor, Table table) {
        tableFieldEditor.table = table;
    }
}

