/*
 * Decompiled with CFR 0.152.
 */
package br.ufma.deinf.gia.labmint.semantics;

import br.ufma.deinf.gia.labmint.document.NclValidatorDocument;
import br.ufma.deinf.gia.labmint.message.MessageList;
import br.ufma.deinf.gia.labmint.semantics.ElementValidation;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Bind
extends ElementValidation {
    public Bind(NclValidatorDocument doc) {
        super(doc);
    }

    public boolean validate(Element eBind) {
        boolean resultado = true;
        if (!this.hasValidBindInterfaceAttribute(eBind)) {
            resultado = false;
        }
        if (!this.hasValidBindDescriptorAttribute(eBind)) {
            resultado = false;
        }
        if (!this.hasValidBindRoleAttribute(eBind)) {
            resultado = false;
        }
        if (!this.hasValidBindComponentAttribute(eBind)) {
            resultado = false;
        }
        return resultado;
    }

    private boolean hasValidBindInterfaceAttribute(Element eBind) {
        String tagName;
        Element childElement;
        Node node;
        int i;
        NodeList nodeList;
        if (!eBind.hasAttribute("interface")) {
            return true;
        }
        String idInterface = eBind.getAttribute("interface");
        if (!eBind.hasAttribute("component")) {
            MessageList.addError((String)this.doc.getId(), (int)3201, (Element)eBind);
            return false;
        }
        String idComponent = eBind.getAttribute("component");
        Element element = this.doc.getElement(idComponent);
        if (element == null) {
            return false;
        }
        Vector<String> referPath = new Vector<String>();
        referPath.add(idComponent);
        while (element.hasAttribute("refer")) {
            nodeList = element.getChildNodes();
            i = 0;
            while (i < nodeList.getLength()) {
                node = nodeList.item(i);
                if (node.getNodeType() == 1) {
                    childElement = (Element)node;
                    tagName = childElement.getTagName();
                    if (tagName.compareTo("area") == 0 && childElement.hasAttribute("id") && childElement.getAttribute("id").compareTo(idInterface) == 0) {
                        return true;
                    }
                    if (tagName.compareTo("property") == 0 && childElement.hasAttribute("name") && childElement.getAttribute("name").compareTo(idInterface) == 0) {
                        return true;
                    }
                    if (tagName.compareTo("port") == 0 && childElement.hasAttribute("id") && childElement.getAttribute("id").compareTo(idInterface) == 0) {
                        return true;
                    }
                    if (tagName.compareTo("switchPort") == 0 && childElement.hasAttribute("id") && childElement.getAttribute("id").compareTo(idInterface) == 0) {
                        return true;
                    }
                }
                ++i;
            }
            idComponent = element.getAttribute("refer");
            if ((element = this.doc.getElement(idComponent)) == null || referPath.contains(idComponent)) {
                return false;
            }
            referPath.add(idComponent);
        }
        if (element == null) {
            return false;
        }
        nodeList = element.getChildNodes();
        i = 0;
        while (i < nodeList.getLength()) {
            node = nodeList.item(i);
            if (node.getNodeType() == 1) {
                childElement = (Element)node;
                tagName = childElement.getTagName();
                if (tagName.compareTo("area") == 0 && childElement.hasAttribute("id") && childElement.getAttribute("id").compareTo(idInterface) == 0) {
                    return true;
                }
                if (tagName.compareTo("property") == 0 && childElement.hasAttribute("name") && childElement.getAttribute("name").compareTo(idInterface) == 0) {
                    return true;
                }
                if (tagName.compareTo("port") == 0 && childElement.hasAttribute("id") && childElement.getAttribute("id").compareTo(idInterface) == 0) {
                    return true;
                }
                if (tagName.compareTo("switchPort") == 0 && childElement.hasAttribute("id") && childElement.getAttribute("id").compareTo(idInterface) == 0) {
                    return true;
                }
            }
            ++i;
        }
        MessageList.addError((String)this.doc.getId(), (int)3202, (Element)eBind);
        return false;
    }

    private boolean hasValidBindDescriptorAttribute(Element eBind) {
        if (eBind.hasAttribute("descriptor")) {
            String idDescriptor = eBind.getAttribute("descriptor");
            Element element = this.doc.getElement(idDescriptor);
            if (element == null) {
                Vector<String> args = new Vector<String>();
                args.add(idDescriptor);
                MessageList.addError((String)this.doc.getId(), (int)3203, (Element)eBind, args);
                return false;
            }
            if (element.getTagName().compareTo("descriptor") != 0 && element.getTagName().compareTo("descriptorSwitch") != 0) {
                Vector<String> args = new Vector<String>();
                args.add(idDescriptor);
                MessageList.addError((String)this.doc.getId(), (int)3203, (Element)eBind, args);
                return false;
            }
        }
        return true;
    }

    private boolean hasValidBindRoleAttribute(Element eBind) {
        return true;
    }

    private boolean hasValidBindComponentAttribute(Element eBind) {
        if (!eBind.hasAttribute("component")) {
            return false;
        }
        String idComponent = eBind.getAttribute("component");
        Element element = this.doc.getElement(idComponent);
        if (element == null) {
            Vector<String> args = new Vector<String>();
            args.add(idComponent);
            MessageList.addError((String)this.doc.getId(), (int)3204, (Element)eBind, args);
            return false;
        }
        if ((element.getTagName().equals("body") || element.getTagName().equals("media") || element.getTagName().equals("context") || element.getTagName().equals("switch")) && this.componentIsInMyContext(eBind)) {
            return true;
        }
        Vector<String> args = new Vector<String>();
        args.add(idComponent);
        MessageList.addError((String)this.doc.getId(), (int)3204, (Element)eBind, args);
        return false;
    }

    private boolean componentIsMyContext(Element eBind) {
        Element eLink = (Element)eBind.getParentNode();
        if (eLink == null) {
            return false;
        }
        Element eContext = (Element)eLink.getParentNode();
        if (eContext == null) {
            return false;
        }
        return (eContext.getTagName().equals("body") || eContext.getTagName().equals("context")) && eContext.hasAttribute("id") && eContext.getAttribute("id").equals(eBind.getAttribute("component"));
    }

    private boolean componentIsInMyContext(Element eBind) {
        if (this.componentIsMyContext(eBind)) {
            return true;
        }
        if (!eBind.hasAttribute("component")) {
            return true;
        }
        Element component = this.doc.getElement(eBind.getAttribute("component"));
        if (component.getTagName().equals("media") && component.hasAttribute("type") && component.getAttribute("type").equals("application/x-ginga-settings")) {
            return true;
        }
        Element eLink = (Element)eBind.getParentNode();
        if (eLink == null) {
            return false;
        }
        Element eContext = (Element)eLink.getParentNode();
        if (eContext == null) {
            return false;
        }
        Element element = this.doc.getElementChild(eContext, eBind.getAttribute("component"));
        if (element == null) {
            return false;
        }
        return element.getTagName().equals("media") || element.getTagName().equals("switch") || element.getTagName().equals("context");
    }
}

