/*
 * Decompiled with CFR 0.152.
 */
package br.ufma.deinf.gia.labmint.xml;

import java.io.IOException;
import java.io.StringReader;
import org.apache.xerces.parsers.DOMParser;
import org.apache.xerces.xni.Augmentations;
import org.apache.xerces.xni.NamespaceContext;
import org.apache.xerces.xni.QName;
import org.apache.xerces.xni.XMLAttributes;
import org.apache.xerces.xni.XMLLocator;
import org.apache.xerces.xni.XNIException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLParserExtend
extends DOMParser {
    private XMLLocator locator;

    public XMLParserExtend() {
        try {
            this.setFeature("http://apache.org/xml/features/dom/defer-node-expansion", false);
            this.setFeature("http://xml.org/sax/features/namespaces", false);
        }
        catch (SAXException e) {
            System.err.println("except" + e);
        }
    }

    public void startDocument(XMLLocator locator, String encoding, NamespaceContext namespaceContext, Augmentations augs) throws XNIException {
        super.startDocument(locator, encoding, namespaceContext, augs);
        this.locator = locator;
        Node node = null;
        try {
            node = (Node)this.getProperty("http://apache.org/xml/properties/dom/current-element-node");
        }
        catch (SAXException ex) {
            System.err.println("except" + ex);
        }
        if (node != null) {
            node.setUserData("startLine", String.valueOf(locator.getLineNumber()), null);
        }
    }

    public void startElement(QName elementQName, XMLAttributes attrList, Augmentations augs) throws XNIException {
        super.startElement(elementQName, attrList, augs);
        Node node = null;
        try {
            node = (Node)this.getProperty("http://apache.org/xml/properties/dom/current-element-node");
        }
        catch (SAXException ex) {
            System.err.println("except" + ex);
        }
        if (node != null) {
            node.setUserData("startLine", String.valueOf(this.locator.getLineNumber()), null);
            node.setUserData("startColumn", String.valueOf(this.locator.getColumnNumber()), null);
            node.setUserData("startCharacterOffset", String.valueOf(this.locator.getCharacterOffset()), null);
            node.setUserData("baseSystemId", this.locator.getBaseSystemId(), null);
        }
    }

    public void parseString(String xmlText) throws SAXException, IOException {
        InputSource inputSource = new InputSource(new StringReader(xmlText));
        this.parse(inputSource);
    }

    public static void main(String[] args) {
        XMLParserExtend myParser = new XMLParserExtend();
        try {
            myParser.parse("testes/teste.ncl");
            Document document = myParser.getDocument();
        }
        catch (SAXException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }
}

