/*
 * Decompiled with CFR 0.152.
 */
package br.ufma.deinf.laws.ncleclipse.actions;

import br.ufma.deinf.laws.ncleclipse.NCLEditor;
import br.ufma.deinf.laws.ncleclipse.NCLMultiPageEditor;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.TextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IEditorActionDelegate;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;

public class CommentSelectionAction
implements IEditorActionDelegate {
    final String commentBegin = "<!--";
    final String commentEnd = "-->";

    public void setActiveEditor(IAction action, IEditorPart targetEditor) {
    }

    public void run(IAction action) {
        IWorkbench wb = PlatformUI.getWorkbench();
        IWorkbenchWindow win = wb.getActiveWorkbenchWindow();
        IWorkbenchPage page = win.getActivePage();
        NCLEditor editor = ((NCLMultiPageEditor)page.getActiveEditor()).getNCLEditor();
        TextSelection selection = (TextSelection)editor.getSelectionProvider().getSelection();
        IDocument doc = editor.getInputDocument();
        try {
            ITypedRegion region = doc.getPartition(selection.getOffset());
            if (region.getType().equals("__xml_comment")) {
                this.uncommentSelection(region, doc);
            } else {
                this.commentSelection(selection, doc);
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public void commentSelection(TextSelection selection, IDocument doc) {
        if (selection.getLength() > 0) {
            try {
                int offset = selection.getOffset();
                doc.replace(offset, 0, "<!--");
                doc.replace(offset += selection.getLength() + "<!--".length(), 0, "-->");
            }
            catch (BadLocationException e) {
                e.printStackTrace();
            }
        } else {
            System.out.println("Comment the range!");
        }
    }

    public void uncommentSelection(ITypedRegion region, IDocument doc) {
        int offset = region.getOffset();
        int endOffset = region.getOffset() + (region.getLength() - "<!--".length() - "-->".length());
        if (!region.getType().equals("__xml_comment")) {
            return;
        }
        try {
            doc.replace(offset, "<!--".length(), "");
            if (doc.get(endOffset, "-->".length()).equals("-->")) {
                doc.replace(endOffset, "-->".length(), "");
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }
}

