/*
 * Decompiled with CFR 0.152.
 */
package br.ufma.deinf.laws.ncleclipse.document;

import br.ufma.deinf.laws.ncl.NCLStructure;
import br.ufma.deinf.laws.ncleclipse.document.NCLSourceDocument;
import br.ufma.deinf.laws.ncleclipse.scanners.XMLPartitionScanner;
import br.ufma.deinf.laws.ncleclipse.scanners.XMLTagScanner;
import br.ufma.deinf.laws.ncleclipse.util.ColorManager;
import br.ufma.deinf.laws.ncleclipse.util.XMLPartitioner;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentPartitioner;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.rules.IPartitionTokenScanner;

public class NCLSourceDocument
extends Document {
    private XMLTagScanner scanner;
    private int tamAttr = 0;
    String currentAttribute;
    private int startAttributeValueOffset = -1;

    public NCLSourceDocument() {
    }

    public NCLSourceDocument(IDocument doc) {
        super(doc.get());
    }

    public NCLSourceDocument(String doc) {
        super(doc);
        XMLPartitioner partitioner = new XMLPartitioner((IPartitionTokenScanner)new XMLPartitionScanner(), new String[]{"__xml_start_tag", "__xml_pi", "__xml_doctype", "__xml_end_tag", "__xml_text", "__xml_cdata", "__xml_comment"});
        partitioner.connect((IDocument)this);
        this.setDocumentPartitioner((IDocumentPartitioner)partitioner);
    }

    public int getFatherPartitionOffset(int documentOffset) {
        try {
            String text;
            ITypedRegion region = this.getPartition(documentOffset);
            int partitionOffset = region.getOffset();
            while (region.getType().equals("__xml_start_tag")) {
                text = this.get(region.getOffset(), region.getLength());
                region = this.getPartition(--documentOffset);
            }
            Stack<Integer> pilha = new Stack<Integer>();
            while (true) {
                text = this.get(region.getOffset(), region.getLength());
                if (region.getType().equals("__xml_end_tag")) {
                    pilha.push(new Integer(1));
                } else if (region.getType().equals("__xml_start_tag") && !text.endsWith("/>")) {
                    if (pilha.size() == 0) break;
                    pilha.pop();
                }
                region = this.getPartition(--partitionOffset);
                partitionOffset = region.getOffset();
            }
            return partitionOffset;
        }
        catch (BadLocationException e) {
            return -1;
        }
    }

    public int getFatherPartitionOffsetFromEndTag(int documentOffset) {
        try {
            ITypedRegion region = this.getPartition(documentOffset);
            int partitionOffset = region.getOffset();
            Stack<Integer> pilha = new Stack<Integer>();
            String text = this.get(region.getOffset(), region.getLength());
            region = this.getPartition(region.getOffset() - 1);
            partitionOffset = region.getOffset();
            while (true) {
                text = this.get(region.getOffset(), region.getLength());
                if (region.getType().equals("__xml_end_tag")) {
                    pilha.push(new Integer(1));
                } else if (region.getType().equals("__xml_start_tag") && !text.endsWith("/>")) {
                    if (pilha.size() == 0) break;
                    pilha.pop();
                }
                region = this.getPartition(--partitionOffset);
                partitionOffset = region.getOffset();
            }
            return partitionOffset;
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public Vector<Integer> getChildrenOffsets(int offset) {
        try {
            Vector<Integer> offsets = new Vector<Integer>();
            ITypedRegion region = this.getPartition(offset);
            String tagname = this.getCurrentTagname(offset);
            if (tagname == null) {
                return offsets;
            }
            String text = this.get(region.getOffset(), region.getLength());
            if (text.endsWith("/>")) {
                return offsets;
            }
            do {
                region = this.getNextPartition(region);
                offset = region.getOffset();
                text = this.get(region.getOffset(), region.getLength());
                if (region.getType().equals("__xml_start_tag")) {
                    offsets.add(offset);
                    continue;
                }
                if (region.getType().equals("__xml_end_tag") && text.equals("</" + tagname + ">")) break;
            } while (!text.equals("</ncl>"));
            return offsets;
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return null;
        }
    }

    public String getFatherTagName(int documentOffset) {
        return this.getCurrentTagname(this.getFatherPartitionOffset(documentOffset));
    }

    public ITypedRegion getPreviousPartition(ITypedRegion r) {
        if (r == null) {
            return null;
        }
        if (r.getOffset() < 1) {
            return null;
        }
        ITypedRegion pr = null;
        try {
            pr = this.getPartition(r.getOffset() - 1);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return pr;
    }

    public ITypedRegion getPreviousTagPartition(int offset) throws BadLocationException {
        ITypedRegion partition = this.getPartition(offset);
        if (partition == null || partition.getType().equals("__xml_start_tag")) {
            return partition;
        }
        return this.getPreviousTagPartition(partition);
    }

    public ITypedRegion getPreviousTagPartition(ITypedRegion r) {
        ITypedRegion partition = this.getPreviousPartition(r);
        while (partition != null && !partition.getType().equals("__xml_start_tag")) {
            partition = this.getPreviousPartition(partition);
        }
        return partition;
    }

    public String getCurrentTagname(int documentOffset) {
        try {
            ITypedRegion region = this.getPartition(documentOffset);
            int partitionOffset = region.getOffset();
            int readLength = region.getLength();
            ColorManager colorManager = new ColorManager();
            this.scanner = new XMLTagScanner(colorManager);
            String text = this.get(partitionOffset, readLength);
            int p = 0;
            String tagname = "";
            char ch = text.charAt(0);
            while (p + 1 < text.length() && Character.isJavaIdentifierPart(text.charAt(p + 1))) {
                ch = text.charAt(++p);
                tagname = String.valueOf(tagname) + ch;
            }
            return tagname;
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return "";
        }
    }

    public String getAttributeValueFromCurrentTagName(int offset, String attribute) {
        int readLength;
        int partitionOffset;
        block14: {
            ITypedRegion region = this.getPartition(offset);
            partitionOffset = region.getOffset();
            readLength = region.getLength();
            if (attribute != null) break block14;
            return null;
        }
        try {
            String text = this.get(partitionOffset, readLength);
            boolean firstQuote = false;
            boolean equal = false;
            String attributeValue = "";
            String attributeName = "";
            int i = 0;
            while (i < text.length()) {
                if (text.charAt(i) == '\"' || text.charAt(i) == '\'') {
                    if (!firstQuote) {
                        firstQuote = true;
                    } else {
                        String[] str = attributeName.split(" ");
                        Vector<String> v = new Vector<String>();
                        String[] stringArray = str;
                        int n = str.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String s = stringArray[n2];
                            if (!s.equals("")) {
                                v.add(s);
                            }
                            ++n2;
                        }
                        if (((String)v.get(v.size() - 1)).equals(attribute)) {
                            return attributeValue;
                        }
                        attributeName = "";
                        attributeValue = "";
                        firstQuote = false;
                        equal = true;
                    }
                } else if (firstQuote) {
                    attributeValue = String.valueOf(attributeValue) + text.charAt(i);
                } else if (text.charAt(i) != '=') {
                    attributeName = String.valueOf(attributeName) + text.charAt(i);
                }
                ++i;
            }
            return null;
        }
        catch (BadLocationException e) {
            return "";
        }
    }

    private int getAttributeSize(int offset, String attr) {
        this.getAttributeValueFromCurrentTagName(offset, attr);
        return this.tamAttr;
    }

    public String getCurrentAttribute(int offset) {
        if (this.isAttributeValue(offset)) {
            return this.currentAttribute;
        }
        return "";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isAttributeValue(int offset) {
        this.startAttributeValueOffset = -1;
        try {
            ITypedRegion region = this.getPartition(offset--);
            if (region.getType() == "__xml_start_tag") {
                int partitionOffset = region.getOffset();
                this.currentAttribute = "";
                boolean firstQuote = true;
                boolean findingAttributeName = false;
                int beginAttributeName = -1;
                int endAttributeName = -1;
                while (offset >= partitionOffset) {
                    char ch = this.getChar(offset--);
                    if (findingAttributeName) {
                        if (Character.isJavaIdentifierPart(ch) || ch == ':') {
                            if (endAttributeName != -1) continue;
                            endAttributeName = offset;
                            continue;
                        }
                        if (Character.isWhitespace(ch) && endAttributeName != -1) {
                            this.currentAttribute = this.get(offset + 2, endAttributeName - offset);
                            return true;
                        }
                        if (Character.isWhitespace(ch)) continue;
                        return false;
                    }
                    if (ch == '\'' || ch == '\"') {
                        if (!firstQuote) {
                            return false;
                        }
                        this.startAttributeValueOffset = offset + 1;
                        firstQuote = false;
                        continue;
                    }
                    if (ch != '=') continue;
                    findingAttributeName = true;
                }
            }
            return false;
        }
        catch (BadLocationException e) {
            return false;
        }
    }

    public int getStartAttributeValueOffset(int offset) {
        if (this.isAttributeValue(offset)) {
            return this.startAttributeValueOffset;
        }
        return -1;
    }

    public boolean isAttribute(int documentOffset) {
        try {
            ITypedRegion region = this.getPartition(documentOffset);
            if (region.getType() == "__xml_start_tag") {
                return !this.isTagname(documentOffset) && !this.isAttributeValue(documentOffset);
            }
            return false;
        }
        catch (BadLocationException e) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean isTagname(int documentOffset) {
        boolean isTagname = false;
        try {
            char ch;
            ITypedRegion region = this.getPartition(documentOffset);
            String text = this.get(region.getOffset(), documentOffset - region.getOffset());
            int p = text.length() - 1;
            do {
                if ((ch = text.charAt(p--)) != '<') continue;
                return true;
            } while (Character.isLetter(ch));
            return false;
        }
        catch (BadLocationException e) {
            return false;
        }
    }

    public boolean isEndTagName(int documentOffset) {
        try {
            ITypedRegion region = this.getPartition(documentOffset);
            return region.getType() == "__xml_end_tag";
        }
        catch (BadLocationException e) {
            return false;
        }
    }

    public ITypedRegion getNextTagPartition(int offset) throws BadLocationException {
        ITypedRegion partition = this.getPartition(offset);
        if (partition == null || partition.getType().equals("__xml_start_tag")) {
            return partition;
        }
        return this.getNextTagPartition(partition);
    }

    public ITypedRegion getNextTagPartition(String tagname, int offset) throws BadLocationException {
        ITypedRegion partition = this.getPartition(offset);
        while (partition != null) {
            if (partition.getType().equals("__xml_start_tag") && this.getCurrentTagname(partition.getOffset()).equals(tagname)) {
                return partition;
            }
            partition = this.getNextTagPartition(partition);
        }
        return null;
    }

    public ITypedRegion getNextTagPartition(ITypedRegion r) {
        ITypedRegion partition = this.getNextPartition(r);
        while (partition != null && !partition.getType().equals("__xml_start_tag")) {
            partition = this.getNextPartition(partition);
        }
        return partition;
    }

    public String getCurrentEndTagName(int documentOffset) {
        ITypedRegion region;
        block4: {
            region = this.getPartition(documentOffset);
            if (region.getType().equals("__xml_end_tag")) break block4;
            return null;
        }
        try {
            int partitionOffset = region.getOffset();
            int readLength = region.getLength();
            String text = this.get(partitionOffset + 1, readLength);
            int p = 0;
            String tagname = "";
            char ch = text.charAt(0);
            while (p + 1 < text.length() && Character.isJavaIdentifierPart(text.charAt(p + 1))) {
                ch = text.charAt(++p);
                tagname = String.valueOf(tagname) + ch;
            }
            return tagname;
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return null;
        }
    }

    public ITypedRegion getNextEndTagPartition(String tagname, int offset) {
        try {
            ITypedRegion partition = this.getPartition(offset);
            while (partition != null) {
                if (partition.getType().equals("__xml_end_tag") && this.getCurrentEndTagName(partition.getOffset()).equals(tagname)) {
                    return partition;
                }
                partition = this.getNextPartition(partition);
            }
        }
        catch (Exception e) {
            return null;
        }
        return null;
    }

    public ITypedRegion getNextEndTagPartition(ITypedRegion r) {
        ITypedRegion partition = this.getNextPartition(r);
        while (partition != null && !partition.getType().equals("__xml_end_tag")) {
            partition = this.getNextPartition(partition);
        }
        return partition;
    }

    public ITypedRegion getNextPartition(ITypedRegion r) {
        if (r == null) {
            return null;
        }
        if (r.getOffset() > this.getLength()) {
            return null;
        }
        ITypedRegion pr = null;
        try {
            pr = this.getPartition(r.getLength() + r.getOffset() + 1);
        }
        catch (BadLocationException e) {
            return null;
        }
        return pr;
    }

    public boolean setAttribute(String id, String attr, String value) {
        return this.setAttribute(id, attr, value, 1);
    }

    public boolean setAttribute(String attr, String value, int offset) {
        try {
            ITypedRegion region = this.getPartition(offset);
            String startTag = this.get(region.getOffset(), region.getLength());
            String attrAtual = this.getAttributeValueFromCurrentTagName(offset, attr);
            int begin = 0;
            String newValue = String.valueOf(attr) + "=\"" + value + "\"";
            if (attrAtual == null) {
                begin = region.getOffset() + region.getLength() - 1;
                if (startTag.endsWith("/>")) {
                    --begin;
                }
                if (!this.get(begin - 1, 1).equals(" ")) {
                    newValue = " " + newValue;
                }
                this.replace(begin, 0, newValue);
            } else {
                int attrOffset = this.getAttributePosition(attr, region.getOffset()) - attr.length() - 1;
                int attrSizeAtual = attrAtual.length();
                begin = region.getOffset() + attrOffset;
                newValue = String.valueOf(attr) + "=\"" + value + "\"";
                if (!this.get(begin - 1, 1).equals(" ")) {
                    newValue = " " + newValue;
                }
                if (!this.get(begin + attrSizeAtual, 1).equals(" ")) {
                    newValue = String.valueOf(newValue) + " ";
                }
                this.replace(begin, attrSizeAtual + attr.length() + 3, newValue);
            }
            return true;
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return false;
        }
    }

    private int getAttributePosition(String attr, int offset) {
        int readLength;
        int partitionOffset;
        block15: {
            ITypedRegion region;
            block14: {
                region = this.getPartition(offset);
                if (region.getType().equals("__xml_start_tag")) break block14;
                return -1;
            }
            partitionOffset = region.getOffset();
            readLength = region.getLength();
            if (attr != null && !attr.equals("")) break block15;
            return -1;
        }
        try {
            String tag = this.get(partitionOffset, readLength);
            boolean firstQuote = false;
            boolean equal = false;
            String attributeValue = "";
            String attributeName = "";
            int index = 0;
            int i = 0;
            while (i < tag.length()) {
                if (tag.charAt(i) == '\"' || tag.charAt(i) == '\'') {
                    if (!firstQuote) {
                        firstQuote = true;
                        index = i;
                    } else {
                        String[] str = attributeName.split(" ");
                        Vector<String> v = new Vector<String>();
                        String[] stringArray = str;
                        int n = str.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String s = stringArray[n2];
                            if (!s.equals("")) {
                                v.add(s);
                            }
                            ++n2;
                        }
                        if (((String)v.get(v.size() - 1)).equals(attr)) break;
                        attributeName = "";
                        attributeValue = "";
                        firstQuote = false;
                        equal = true;
                    }
                } else if (firstQuote) {
                    attributeValue = String.valueOf(attributeValue) + tag.charAt(i);
                } else if (tag.charAt(i) != '=') {
                    attributeName = String.valueOf(attributeName) + tag.charAt(i);
                }
                ++i;
            }
            return index;
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return -1;
        }
    }

    public boolean removeAttribute(String attr, int offset) {
        int index;
        int pad;
        String tag;
        ITypedRegion region;
        block8: {
            block7: {
                region = this.getPartition(offset);
                if (region.getType().equals("__xml_start_tag")) break block7;
                return false;
            }
            tag = this.get(region.getOffset(), region.getLength());
            pad = 0;
            index = this.getAttributePosition(attr, offset);
            if (index != -1) break block8;
            return false;
        }
        try {
            int i = index - 1;
            while (i > 0) {
                if (tag.charAt(i) == attr.charAt(attr.length() - 1)) break;
                --i;
                ++pad;
            }
            boolean firstQuote = false;
            int begin = index - pad - attr.length();
            pad = 0;
            int i2 = begin + attr.length();
            while (i2 < tag.length()) {
                if (tag.charAt(i2) == '\"') {
                    if (firstQuote) break;
                    firstQuote = true;
                }
                ++i2;
                ++pad;
            }
            int end = attr.length() + pad + 1;
            this.replace(begin += region.getOffset(), end, "");
            return true;
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return false;
        }
    }

    public boolean setAttribute(String id, String attr, String value, int offset) {
        ITypedRegion region;
        block10: {
            try {
                region = this.getNextTagPartition(offset);
                if (region == null) {
                    throw new BadLocationException();
                }
                String startTag = this.get(region.getOffset(), region.getLength());
                String currentId = this.getAttributeValueFromCurrentTagName(region.getOffset(), "id");
                if (currentId == null || !currentId.equals(id)) break block10;
                String attrAtual = this.getAttributeValueFromCurrentTagName(region.getOffset(), attr);
                int begin = 0;
                String newValue = String.valueOf(attr) + "=\"" + value + "\"";
                if (attrAtual == null) {
                    begin = region.getOffset() + region.getLength() - 1;
                    if (startTag.endsWith("/>")) {
                        --begin;
                    }
                    if (!this.get(begin - 1, 1).equals(" ")) {
                        newValue = " " + newValue;
                    }
                    this.replace(begin, 0, newValue);
                } else {
                    String text = this.get(region.getOffset(), region.getLength());
                    int attrOffset = text.indexOf(attr);
                    int attrSizeAtual = attrAtual.length();
                    begin = region.getOffset() + attrOffset;
                    newValue = String.valueOf(attr) + "=\"" + value + "\"";
                    if (!this.get(begin - 1, 1).equals(" ")) {
                        newValue = " " + newValue;
                    }
                    if (!this.get(begin + attrSizeAtual, 1).equals(" ")) {
                        newValue = String.valueOf(newValue) + " ";
                    }
                    this.replace(begin, attrSizeAtual + attr.length() + 3, newValue);
                }
                return true;
            }
            catch (BadLocationException e) {
                return false;
            }
        }
        this.setAttribute(id, attr, value, region.getOffset() + region.getLength() + 1);
        return true;
    }

    public boolean setAttributeFromTagname(String tagname, String attr, String value, int offset) {
        ITypedRegion region;
        block10: {
            try {
                region = this.getNextTagPartition(offset);
                if (region == null) {
                    throw new BadLocationException();
                }
                String startTag = this.get(region.getOffset(), region.getLength());
                String currentTagname = this.getCurrentTagname(region.getOffset());
                if (currentTagname == null || !currentTagname.equals(tagname)) break block10;
                String attrAtual = this.getAttributeValueFromCurrentTagName(region.getOffset(), attr);
                int begin = 0;
                String newValue = String.valueOf(attr) + "=\"" + value + "\"";
                if (attrAtual == null) {
                    begin = region.getOffset() + region.getLength() - 1;
                    if (startTag.endsWith("/>")) {
                        --begin;
                    }
                    if (!this.get(begin - 1, 1).equals(" ")) {
                        newValue = " " + newValue;
                    }
                    this.replace(begin, 0, newValue);
                } else {
                    String text = this.get(region.getOffset(), region.getLength());
                    int attrOffset = this.getAttributePosition(attr, offset);
                    int attrSizeAtual = this.getAttributeSize(offset, attr);
                    begin = region.getOffset() + attrOffset;
                    newValue = String.valueOf(attr) + "=\"" + value + "\"";
                    if (!this.get(begin - 1, 1).equals(" ")) {
                        newValue = " " + newValue;
                    }
                    if (!this.get(begin + attrSizeAtual, 1).equals(" ")) {
                        newValue = String.valueOf(newValue) + " ";
                    }
                    this.replace(begin, attrSizeAtual, newValue);
                }
                return true;
            }
            catch (BadLocationException e) {
                return false;
            }
        }
        this.setAttribute(tagname, attr, value, region.getOffset() + region.getLength() + 1);
        return true;
    }

    public List<String> getAttributesTyped(int offset) {
        ArrayList<String> list = new ArrayList<String>();
        try {
            ITypedRegion region = this.getPartition(offset);
            if (region.getType() == "__xml_start_tag") {
                String currentPartition = this.get(region.getOffset(), region.getLength());
                int lt_pos = currentPartition.substring(1).indexOf(60);
                if (lt_pos >= 0) {
                    currentPartition = currentPartition.substring(0, lt_pos + 1);
                }
                Pattern p = Pattern.compile("\\s[a-zA-Z]+");
                Matcher m = p.matcher(currentPartition);
                while (m.find()) {
                    list.add(currentPartition.substring(m.start() + 1, m.end()));
                }
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return list;
    }

    public void removeElement(String id) {
        this.removeElement(id, 0);
    }

    public boolean removeElement(String id, int offset) {
        try {
            int elementOffset = this.getElementOffset(id);
            ITypedRegion region = this.getNextTagPartition(elementOffset);
            String tag = this.get(region.getOffset(), region.getLength());
            if (tag.endsWith("/>")) {
                this.replace(region.getOffset(), region.getLength(), "");
            } else {
                String tagname = this.getCurrentTagname(offset);
                ITypedRegion endTagRegion = this.getNextEndTagPartition(tagname, offset);
                int begin = region.getOffset();
                int end = endTagRegion.getOffset() + endTagRegion.getLength() - begin;
                this.replace(begin, end, "");
            }
            return true;
        }
        catch (BadLocationException e) {
            return true;
        }
    }

    public boolean removeElement(int offset) {
        try {
            ITypedRegion region = this.getNextTagPartition(offset);
            String tag = this.get(region.getOffset(), region.getLength());
            if (tag.endsWith("/>")) {
                this.replace(region.getOffset(), region.getLength(), "");
            } else {
                String tagname = this.getCurrentTagname(offset);
                ITypedRegion endTagRegion = this.getNextEndTagPartition(tagname, offset);
                int begin = region.getOffset();
                int end = endTagRegion.getOffset() + endTagRegion.getLength() - begin;
                this.replace(begin, end, "");
            }
            return true;
        }
        catch (BadLocationException e) {
            return true;
        }
    }

    public boolean addElement(String tagname, int offset) {
        try {
            this.replace(offset, 1, "<" + tagname + ">\n</" + tagname + ">\n");
        }
        catch (BadLocationException e) {
            return false;
        }
        return true;
    }

    public int getBaseOffset(String base, String id) {
        if (base == null || base.equals("")) {
            return -1;
        }
        try {
            ITypedRegion region = this.getPartition(0);
            region = this.getNextTagPartition(region);
            String tagname = this.getCurrentTagname(region.getOffset());
            while (!tagname.equals("/head")) {
                if (tagname.equals(base)) {
                    if (id == null || id.equals("")) {
                        return region.getOffset();
                    }
                    String baseId = this.getAttributeValueFromCurrentTagName(region.getOffset(), "id");
                    if (baseId != null && baseId.equals(id)) {
                        return region.getOffset();
                    }
                }
                if ((region = this.getNextTagPartition(region)) == null) break;
                tagname = this.getCurrentTagname(region.getOffset());
            }
            return -1;
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return -1;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean addElement(String tagname, String id, int elementOffset) {
        try {
            Map.Entry entry;
            String elementTagName;
            Map elementChildren;
            NCLStructure nclStructure = NCLStructure.getInstance();
            int fatherOffset = this.getFatherPartitionOffset(elementOffset);
            Map nesting = nclStructure.getNesting();
            Map headChildren = (Map)nesting.get("head");
            Iterator it = headChildren.entrySet().iterator();
            do {
                if (it.hasNext()) continue;
                String elementTagname = this.getCurrentTagname(elementOffset);
                if (elementTagname.equals("mapping") || elementTagname.equals("bind")) {
                    fatherOffset = this.getFatherPartitionOffset(this.getFatherPartitionOffset(elementOffset));
                }
                ITypedRegion region = this.getPartition(fatherOffset);
                String indent = String.valueOf(this.getIndentLine(fatherOffset)) + "\t";
                String tagStructure = this.computeTagStructure(tagname, indent, id);
                this.replace(region.getOffset() + region.getLength(), 0, "\n" + indent + tagStructure);
                return true;
            } while ((elementChildren = (Map)nesting.get(elementTagName = (String)(entry = it.next()).getKey())) == null || !elementChildren.containsKey(tagname));
            fatherOffset = this.getBaseOffset(elementTagName, "");
            if (fatherOffset != -1) {
                ITypedRegion region = this.getPartition(fatherOffset);
                String indent = String.valueOf(this.getIndentLine(fatherOffset)) + "\t";
                String tagStructure = this.computeTagStructure(tagname, indent, id);
                this.replace(region.getOffset() + region.getLength(), 0, "\n" + indent + tagStructure);
                return true;
            }
            fatherOffset = this.getBaseOffset("head", "");
            ITypedRegion region = this.getPartition(fatherOffset);
            String indent = String.valueOf(this.getIndentLine(fatherOffset)) + "\t";
            String tagStructure = this.computeTagStructure(elementTagName, indent, "");
            this.replace(region.getOffset() + region.getLength(), 0, "\n" + indent + tagStructure);
            fatherOffset = this.getBaseOffset(elementTagName, "");
            region = this.getPartition(fatherOffset);
            indent = String.valueOf(this.getIndentLine(fatherOffset)) + "\t";
            tagStructure = this.computeTagStructure(tagname, indent, id);
            this.replace(region.getOffset() + region.getLength(), 0, "\n" + indent + tagStructure);
            return true;
        }
        catch (BadLocationException e) {
            return false;
        }
    }

    public boolean addChild(String child, String attribute, String value, int elementOffset) {
        try {
            ITypedRegion region = this.getPartition(elementOffset);
            String indent = String.valueOf(this.getIndentLine(elementOffset)) + "\t";
            String tagStructue = this.computeTagStructure(child, indent, "");
            this.replace(region.getOffset() + region.getLength(), 0, "\n" + indent + tagStructue);
            region = this.getNextTagPartition(region);
            String tag = this.get(region.getOffset(), region.getLength());
            this.setAttribute(attribute, value, region.getOffset());
            return true;
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return false;
        }
    }

    private String computeTagStructure(String tagname, String indent, String id) {
        String ret;
        NCLStructure nclStructure = NCLStructure.getInstance();
        Map atts = nclStructure.getAttributes(tagname);
        Map children = nclStructure.getChildrenCardinality(tagname);
        Iterator it = atts.entrySet().iterator();
        String attributes = "";
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            if (!((Boolean)entry.getValue()).booleanValue()) continue;
            String attr = (String)entry.getKey();
            attributes = !id.equals("") && attr.equals("id") ? String.valueOf(attributes) + " " + attr + "=\"" + id + "\"" : String.valueOf(attributes) + " " + attr + "=\"\"";
        }
        if (children.size() == 0) {
            ret = "<" + tagname + attributes + "/>" + "\r\n" + indent;
        } else {
            ret = "<" + tagname + attributes + ">" + "\r\n" + indent + "\t";
            if (tagname.equals("context")) {
                ret = String.valueOf(ret) + "<port id=\"\" component=\"\" />";
            } else if (tagname.equals("causalConnector")) {
                ret = String.valueOf(ret) + "<simpleCondition role=\"\" />\n" + indent + "\t" + "<simpleAction role=\"\" />";
            }
            ret = String.valueOf(ret) + "\r\n" + indent + "</" + tagname + ">";
        }
        return ret;
    }

    public boolean hasElementWithId(String id) {
        return this.hasElementWithId(id, 1);
    }

    public boolean hasElementWithId(String id, int offset) {
        return this.hasElementWithAttribute("id", id, offset);
    }

    public boolean hasElementWithAttribute(String attr, String value, int offset) {
        return this.getElementOffset(attr, value, offset) != -1;
    }

    public int getElementOffset(String attr, String value, int offset) {
        try {
            ITypedRegion region = this.getNextTagPartition(offset);
            if (region == null) {
                throw new BadLocationException();
            }
            String startTag = this.get(region.getOffset(), region.getLength());
            String currentAttr = this.getAttributeValueFromCurrentTagName(region.getOffset(), attr);
            if (currentAttr != null && currentAttr.equals(value)) {
                return region.getOffset();
            }
            return this.getElementOffset(attr, value, region.getOffset() + region.getLength() + 1);
        }
        catch (BadLocationException e) {
            return -1;
        }
    }

    public ArrayList<String> getAllElementsOfType(String type) {
        block5: {
            if (!type.equals("")) break block5;
            return null;
        }
        try {
            String partition;
            ArrayList<String> ids = new ArrayList<String>();
            ITypedRegion region = this.getPartition(0);
            do {
                String id;
                int offset;
                String tagName;
                partition = this.get(region.getOffset(), region.getLength());
                if (region.getType().equals("__xml_start_tag") && (tagName = this.getCurrentTagname(offset = region.getOffset())) != null && !tagName.equals("") && tagName.equals(type) && (id = this.getAttributeValueFromCurrentTagName(offset, "id")) != null && !id.equals("")) {
                    ids.add(id);
                }
                region = this.getNextPartition(region);
            } while (!partition.equals("</ncl>"));
            return ids;
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return new ArrayList<String>();
        }
    }

    public int getElementOffset(String id) {
        try {
            return this.getElementOffset(id, 1);
        }
        catch (BadLocationException e) {
            return -1;
        }
    }

    public int getElementOffset(String id, int offset) throws BadLocationException {
        ITypedRegion region = this.getNextTagPartition(offset);
        if (region == null) {
            throw new BadLocationException();
        }
        String currentId = this.getAttributeValueFromCurrentTagName(region.getOffset(), "id");
        if (currentId != null && currentId.equals(id)) {
            return offset;
        }
        return this.getElementOffset(id, region.getOffset() + region.getLength() + 1);
    }

    public static NCLSourceDocument createNCLSourceDocumentFromIDocument(IDocument doc) {
        if (doc instanceof NCLSourceDocument) {
            return (NCLSourceDocument)doc;
        }
        NCLSourceDocument document = new NCLSourceDocument();
        document.set(doc.get());
        XMLPartitioner partitioner = new XMLPartitioner((IPartitionTokenScanner)new XMLPartitionScanner(), new String[]{"__xml_start_tag", "__xml_pi", "__xml_doctype", "__xml_end_tag", "__xml_text", "__xml_cdata", "__xml_comment"});
        partitioner.connect((IDocument)document);
        document.setDocumentPartitioner((IDocumentPartitioner)partitioner);
        return document;
    }

    public List<String> getParentList(int offset) {
        int parentOffset;
        ArrayList<String> parents = new ArrayList<String>();
        while ((parentOffset = this.getFatherPartitionOffset(offset)) >= 0) {
            parents.add(this.getAttributeValueFromCurrentTagName(parentOffset, "id"));
            offset = parentOffset;
        }
        return parents;
    }

    public int getOffsetByID(String id) {
        return this.getOffsetByValue("id", id);
    }

    public int getOffsetByValue(String attribute, String value) {
        block5: {
            if (attribute != null && value != null) break block5;
            return -1;
        }
        try {
            String t;
            ITypedRegion region = this.getPartition(0);
            do {
                String tagId;
                t = this.get(region.getOffset(), region.getLength());
                if (region.getType().equals("__xml_start_tag") && (tagId = this.getAttributeValueFromCurrentTagName(region.getOffset(), attribute)) != null && !tagId.equals("") && tagId.equals(value)) {
                    return region.getOffset();
                }
                region = this.getNextPartition(region);
            } while (!t.equals("</ncl>"));
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        return -1;
    }

    public Vector<Integer> getAllTagsWithAttribute(String attribute) {
        Vector<Integer> aliasOffset = new Vector<Integer>();
        try {
            String t;
            ITypedRegion region = this.getPartition(0);
            do {
                String att;
                t = this.get(region.getOffset(), region.getLength());
                if (region.getType().equals("__xml_start_tag") && (att = this.getAttributeValueFromCurrentTagName(region.getOffset(), attribute)) != null && !att.equals("")) {
                    aliasOffset.add(region.getOffset());
                }
                region = this.getNextPartition(region);
            } while (!t.equals("</ncl>") && region != null);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return aliasOffset;
        }
        return aliasOffset;
    }

    public void setAttributefromTag(String id, String attr, String path, int offset) {
        try {
            if (offset == -1) {
                return;
            }
            ITypedRegion region = this.getPartition(offset);
            int off = region.getOffset();
            String text = this.get(region.getOffset(), region.getLength());
            boolean firstQuote = false;
            String attributeName = "";
            String attributeValue = "";
            int i = 0;
            while (i < text.length()) {
                if (text.charAt(i) == '\"' || text.charAt(i) == '\'') {
                    if (!firstQuote) {
                        firstQuote = true;
                    } else {
                        String[] str = attributeName.split(" ");
                        Vector<String> v = new Vector<String>();
                        String[] stringArray = str;
                        int n = str.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String s = stringArray[n2];
                            if (!s.equals("")) {
                                v.add(s);
                            }
                            ++n2;
                        }
                        if (((String)v.get(v.size() - 1)).equals(attr)) {
                            this.replace(off + i - attributeValue.length(), attributeValue.length(), path);
                            return;
                        }
                        attributeName = "";
                        attributeValue = "";
                        firstQuote = false;
                    }
                } else if (firstQuote) {
                    attributeValue = String.valueOf(attributeValue) + text.charAt(i);
                } else if (text.charAt(i) != '=') {
                    attributeName = String.valueOf(attributeName) + text.charAt(i);
                }
                ++i;
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    public String getIndentLine(int offset) {
        int ident = 0;
        int space = 0;
        try {
            char c;
            while ((c = this.getChar(--offset)) != '\n') {
                if (c == '\t') {
                    ++ident;
                    continue;
                }
                if (c == ' ') {
                    ++space;
                    continue;
                }
                ident = 0;
                space = 0;
            }
        }
        catch (BadLocationException e) {
            ident = 0;
            space = 0;
        }
        String str = "";
        int i = 0;
        while (i < ident) {
            str = String.valueOf(str) + "\t";
            ++i;
        }
        i = 0;
        while (i < space) {
            str = String.valueOf(str) + " ";
            ++i;
        }
        return str;
    }

    public void correctNCLStructure() {
        try {
            ITypedRegion region = this.getPartition(0);
            Stack<StackElement> stack = new Stack<StackElement>();
            String tagname = this.getCurrentTagname(region.getOffset());
            int lastOffset = 0;
            do {
                if (region.getType().equals("__xml_start_tag")) {
                    String tag = this.get(region.getOffset(), region.getLength());
                    if (!tag.endsWith("/>")) {
                        StackElement element = new StackElement(this);
                        element.element = new String(tagname);
                        element.offset = region.getOffset();
                        stack.push(element);
                    }
                } else if (region.getType().equals("__xml_end_tag")) {
                    if (stack.empty()) {
                        this.replace(region.getOffset(), region.getLength(), "");
                    } else {
                        StackElement top = (StackElement)stack.pop();
                        if (!top.element.equals(tagname.substring(1))) {
                            this.addEndtag(top.offset);
                            if (!stack.empty()) {
                                top = (StackElement)stack.peek();
                                region = this.getPartition(top.offset);
                            }
                        }
                    }
                }
                lastOffset = region.getOffset() + region.getLength();
                while ((region = this.getNextPartition(region)) != null && (tagname = this.getTagname(region.getOffset())).equals("")) {
                }
            } while (region != null && !tagname.equals("/ncl"));
            while (stack.size() > 0) {
                StackElement element = (StackElement)stack.pop();
                if (element.element.equals("ncl")) continue;
                this.addEndtag(element.offset);
            }
            ITypedRegion lastRegion = this.getPartition(this.get().length() - 1);
            while (!lastRegion.getType().equals("__xml_end_tag")) {
                lastRegion = this.getPreviousPartition(lastRegion);
            }
            String tag = this.get(lastRegion.getOffset(), lastRegion.getLength());
            if (!tag.equals("</ncl>")) {
                this.replace(lastRegion.getOffset() + lastRegion.getLength(), 0, "\n</ncl>");
            }
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean addEndtag(int offset) {
        try {
            int lastOffset;
            ITypedRegion region = this.getPartition(offset);
            String tagname = this.getTagname(region.getOffset());
            String indent = this.getIndentLine(region.getOffset());
            NCLStructure nclStructure = NCLStructure.getInstance();
            Map nesting = nclStructure.getNesting();
            Map children = (Map)nesting.get(tagname);
            if (children == null) {
                this.replace(region.getOffset() + region.getLength() - 1, 0, "/");
                return true;
            }
            boolean hasChild = false;
            while (true) {
                String childTagname;
                if (tagname.equals("/ncl")) {
                    return false;
                }
                lastOffset = region.getOffset() + region.getLength();
                while ((childTagname = this.getTagname((region = this.getNextPartition(region)).getOffset())).equals("")) {
                }
                String tag = this.get(region.getOffset(), region.getLength());
                if (region.getType().equals("__xml_start_tag")) {
                    if (!children.containsKey(childTagname)) {
                        if (hasChild) {
                            this.replace(lastOffset, 0, "\n" + indent + "</" + tagname + ">");
                            return true;
                        }
                        this.replace(lastOffset - 1, 0, "/");
                        return true;
                    }
                    if (!tag.endsWith("/>")) {
                        region = this.getEndTagPartition(region);
                    }
                    hasChild = true;
                    continue;
                }
                if (region.getType().equals("__xml_end_tag")) break;
            }
            this.replace(lastOffset, 0, "\n" + indent + "</" + tagname + ">");
            return true;
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return false;
        }
    }

    public ITypedRegion getEndTagPartition(ITypedRegion region) {
        String tag;
        block12: {
            block11: {
                if (region.getType().equals("__xml_start_tag") && region != null) break block11;
                return null;
            }
            tag = this.get(region.getOffset(), region.getLength());
            if (!tag.endsWith("/>")) break block12;
            return null;
        }
        try {
            String tagname = this.getTagname(region.getOffset());
            int stack = 0;
            while (true) {
                String childTagname;
                if ((childTagname = this.getTagname((region = this.getNextPartition(region)).getOffset())).equals("")) {
                    continue;
                }
                tag = this.get(region.getOffset(), region.getLength());
                if (region.getType().equals("__xml_start_tag")) {
                    if (!tag.endsWith("/>") && childTagname.equals(tagname)) {
                        ++stack;
                    }
                } else if (region.getType().equals("__xml_end_tag") && tagname.equals(childTagname.substring(1))) {
                    if (stack == 0) {
                        return region;
                    }
                    --stack;
                }
                if (tagname.equals("/ncl")) break;
            }
            return null;
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return null;
        }
    }

    private String getTagname(int offset) {
        try {
            ITypedRegion region = this.getPartition(offset);
            if (region.getType().equals("__xml_start_tag")) {
                return this.getCurrentTagname(region.getOffset());
            }
            if (region.getType().equals("__xml_end_tag")) {
                return "/" + this.getCurrentEndTagName(region.getOffset());
            }
            return "";
        }
        catch (BadLocationException e) {
            e.printStackTrace();
            return "";
        }
    }
}

