/*
 * Decompiled with CFR 0.152.
 */
package br.ufma.deinf.laws.ncleclipse.outline;

import br.ufma.deinf.laws.ncleclipse.xml.XMLAttribute;
import br.ufma.deinf.laws.ncleclipse.xml.XMLElement;
import br.ufma.deinf.laws.ncleclipse.xml.XMLTree;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.BadPositionCategoryException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.Position;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class OutlineContentHandler
extends DefaultHandler
implements ContentHandler {
    private XMLTree dtdTree;
    private XMLElement dtdElement;
    private Locator locator;
    private IDocument document;
    private String positionCategory;

    @Override
    public void setDocumentLocator(Locator locator) {
        this.locator = locator;
    }

    @Override
    public void startElement(String namespace, String localname, String qName, Attributes attributes) throws SAXException {
        int lineNumber = this.locator.getLineNumber() - 1;
        XMLElement element = new XMLElement(qName);
        int startPosition = this.getOffsetFromLine(lineNumber);
        Position position = new Position(startPosition);
        this.addPosition(position);
        element.setPosition(position);
        if (this.dtdTree == null) {
            this.dtdTree = new XMLTree();
            this.dtdTree.setRootElement(element);
        }
        if (attributes != null) {
            int attributeLength = attributes.getLength();
            int i = 0;
            while (i < attributeLength) {
                String value = attributes.getValue(i);
                String localName = attributes.getQName(i);
                element.addChildAttribute(new XMLAttribute(localName, value));
                ++i;
            }
        }
        if (this.dtdElement != null) {
            this.dtdElement.addChildElement(element);
        }
        this.dtdElement = element;
    }

    @Override
    public void endElement(String namespace, String localname, String qName) throws SAXException {
        int lineNumber = this.locator.getLineNumber();
        int endPosition = this.getOffsetFromLine(lineNumber);
        if (this.dtdElement != null) {
            Position position = this.dtdElement.getPosition();
            int length = endPosition - position.getOffset();
            position.setLength(length);
            this.dtdElement = this.dtdElement.getParent();
        }
    }

    private void addPosition(Position position) {
        try {
            this.document.addPosition(this.positionCategory, position);
        }
        catch (BadLocationException e) {
            e.printStackTrace();
        }
        catch (BadPositionCategoryException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void endDocument() throws SAXException {
        super.endDocument();
    }

    private int getOffsetFromLine(int lineNumber) {
        int offset = 0;
        try {
            offset = this.document.getLineOffset(lineNumber);
        }
        catch (BadLocationException e) {
            try {
                offset = this.document.getLineOffset(lineNumber - 1);
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        return offset;
    }

    public XMLElement getRootElement() {
        return this.dtdTree.getRootElement();
    }

    public void setDocument(IDocument document) {
        this.document = document;
    }

    public void setPositionCategory(String positionCategory) {
        this.positionCategory = positionCategory;
    }
}

